/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.memoryleakfix.mixin.readResourcesLeak;

import com.mojang.blaze3d.platform.TextureUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={TextureUtil.class}, remap=false)
public class TextureUtil_freeBufferMixin {
    @Inject(method={"readResource(Ljava/io/InputStream;)Ljava/nio/ByteBuffer;"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lorg/lwjgl/system/MemoryUtil;memAlloc(I)Ljava/nio/ByteBuffer;", shift=At.Shift.BY, by=2, ordinal=0)}, cancellable=true)
    private static void readResourceWithoutLeak1(InputStream inputStream, CallbackInfoReturnable<ByteBuffer> cir, ByteBuffer byteBuf, FileInputStream fileInputStream, FileChannel fileChannel) throws IOException {
        try {
            while (fileChannel.read(byteBuf) != -1) {
            }
        }
        catch (IOException e) {
            MemoryUtil.memFree((Buffer)byteBuf);
            throw e;
        }
        cir.setReturnValue((Object)byteBuf);
    }

    @Inject(method={"readResource(Ljava/io/InputStream;)Ljava/nio/ByteBuffer;"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Ljava/nio/channels/Channels;newChannel(Ljava/io/InputStream;)Ljava/nio/channels/ReadableByteChannel;", shift=At.Shift.BY, by=2, ordinal=0)}, cancellable=true)
    private static void readResourceWithoutLeak2(InputStream inputStream, CallbackInfoReturnable<ByteBuffer> cir, ByteBuffer byteBuf, ReadableByteChannel readableByteChannel) throws IOException {
        try {
            while (readableByteChannel.read(byteBuf) != -1) {
                if (byteBuf.remaining() != 0) continue;
                byteBuf = MemoryUtil.memRealloc((ByteBuffer)byteBuf, (int)(byteBuf.capacity() * 2));
            }
        }
        catch (IOException e) {
            MemoryUtil.memFree((Buffer)byteBuf);
            throw e;
        }
        cir.setReturnValue((Object)byteBuf);
    }
}

